/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.pavocado.exoticbirds.config.ExoticBirdsConfig;
import net.pavocado.exoticbirds.container.ContainerPelican;
import net.pavocado.exoticbirds.entity.EntityAbstractSwimmingBird;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;

public class EntityPelican
extends EntityAbstractSwimmingBird
implements INamedContainerProvider {
    private static final Ingredient BREEDING_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196086_aW, Items.field_196087_aX, Items.field_196088_aY});
    private static final Ingredient TAMING_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196102_ba, Items.field_196104_bb});
    private static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.func_187226_a(EntityPelican.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> RING_COLOR = EntityDataManager.func_187226_a(EntityPelican.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.func_200696_a((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/pelican/pelican_american.png"));
        hashMap.put(1, new ResourceLocation("exoticbirds:textures/entity/pelican/pelican_australian.png"));
    });
    public ItemStackHandler pelicanInventory;
    private LazyOptional<?> itemHandler = null;
    private FishUpFishGoal fishUpGoal;

    public EntityPelican(EntityType<? extends EntityPelican> type, World worldIn) {
        super(type, worldIn, new ItemStack((IItemProvider)ExoticBirdsItems.PELICAN_EGG.get()), BIRD_TEXTURES.size(), true, false);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.initPelicanInventory();
    }

    protected void func_184651_r() {
        this.fishUpGoal = new FishUpFishGoal();
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.4));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 5.0f, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new TemptGoal(this, 1.0, BREEDING_ITEMS, false));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new FishUpFishGoal());
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 14.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    public static boolean canSpawnInBiomeStatic(String biomeName, Biome.Category category, Biome.RainType rainType, float temperature) {
        return !ExoticBirdsConfig.blacklistedBiomesPelican.contains(biomeName) && !ExoticBirdsConfig.blacklistedSpawningBiomes.contains(biomeName) && (category == Biome.Category.OCEAN || category == Biome.Category.RIVER || category == Biome.Category.BEACH) && temperature >= 0.5f;
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    @Override
    public List<String> getBlacklistedDimensions() {
        return ExoticBirdsConfig.blacklistedDimensionsPelican;
    }

    @Override
    public List<ItemStack> getBreedingItems() {
        return Lists.newArrayList((Object[])BREEDING_ITEMS.func_193365_a());
    }

    @Override
    public List<ItemStack> getTamingItems() {
        return Lists.newArrayList((Object[])TAMING_ITEMS.func_193365_a());
    }

    protected void func_70619_bc() {
        this.field_70180_af.func_187227_b(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
        this.field_70180_af.func_187214_a(RING_COLOR, (Object)DyeColor.RED.func_196059_a());
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 0.6f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public EntityPelican func_241840_a(ServerWorld world, AgeableEntity ageable) {
        EntityPelican entityPelican = (EntityPelican)((EntityType)ExoticBirdsEntities.PELICAN.get()).func_200721_a((World)world);
        if (entityPelican != null) {
            entityPelican.setVariant(this.getChildVariant());
            UUID uuid = this.func_184753_b();
            if (uuid != null) {
                entityPelican.func_184754_b(uuid);
                entityPelican.func_70903_f(true);
            }
        }
        return entityPelican;
    }

    public boolean func_70877_b(ItemStack stack) {
        return BREEDING_ITEMS.test(stack);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? 0.7f : 1.1f;
    }

    public DyeColor getRingColor() {
        return DyeColor.func_196056_a((int)((Integer)this.field_70180_af.func_187225_a(RING_COLOR)));
    }

    public void setRingColor(DyeColor ringColor) {
        this.field_70180_af.func_187227_b(RING_COLOR, (Object)ringColor.func_196059_a());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.pelicanInventory.deserializeNBT(compound.func_74775_l("inventory"));
        if (compound.func_150297_b("RingColor", 99)) {
            this.setRingColor(DyeColor.func_196056_a((int)compound.func_74762_e("RingColor")));
        }
        if (this.fishUpGoal != null) {
            this.fishUpGoal.timeUntilFish = compound.func_74762_e("FishTime");
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("inventory", (INBT)this.pelicanInventory.serializeNBT());
        compound.func_74774_a("RingColor", (byte)this.getRingColor().func_196059_a());
        if (this.fishUpGoal != null) {
            compound.func_74768_a("FishTime", this.fishUpGoal.timeUntilFish);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionResultType func_230254_b_(PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        if (this.field_70170_p.field_72995_K) {
            if (this.func_70909_n() && this.func_152114_e((LivingEntity)playerIn)) {
                return ActionResultType.SUCCESS;
            }
            boolean flag = this.func_152114_e((LivingEntity)playerIn) || this.func_70909_n() || TAMING_ITEMS.test(itemstack) && !this.func_70909_n();
            return flag ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        if (this.func_70909_n()) {
            if (this.func_70877_b(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                this.func_70691_i(item.func_219967_s().func_221466_a());
                return ActionResultType.SUCCESS;
            }
            if (item instanceof DyeItem) {
                DyeColor dyecolor = ((DyeItem)item).func_195962_g();
                if (dyecolor == this.getRingColor()) return super.func_230254_b_(playerIn, handIn);
                this.setRingColor(dyecolor);
                if (playerIn.field_71075_bZ.field_75098_d) return ActionResultType.SUCCESS;
                itemstack.func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
            if (playerIn.func_225608_bj_() && this.func_152114_e((LivingEntity)playerIn)) {
                if (itemstack != ItemStack.field_190927_a) return ActionResultType.PASS;
                this.openGUI(playerIn);
                return ActionResultType.SUCCESS;
            }
            ActionResultType actionresulttype = super.func_230254_b_(playerIn, handIn);
            if (actionresulttype.func_226246_a_() && !this.func_70631_g_() || !this.func_152114_e((LivingEntity)playerIn)) return actionresulttype;
            boolean shouldSit = !this.func_233685_eM_();
            this.func_233687_w_(shouldSit);
            this.field_70703_bu = false;
            this.field_70699_by.func_75499_g();
            return ActionResultType.SUCCESS;
        }
        if (!TAMING_ITEMS.test(itemstack)) return super.func_230254_b_(playerIn, handIn);
        if (!playerIn.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)playerIn)) {
            this.func_193101_c(playerIn);
            this.field_70699_by.func_75499_g();
            this.func_233687_w_(true);
            this.func_70606_j(14.0f);
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            return ActionResultType.SUCCESS;
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
        }
        return ActionResultType.SUCCESS;
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.pelicanInventory != null) {
            for (int i = 0; i < this.pelicanInventory.getSlots(); ++i) {
                ItemStack itemstack = this.pelicanInventory.getStackInSlot(i);
                if (itemstack.func_190926_b()) continue;
                this.func_199701_a_(itemstack);
            }
        }
    }

    public void openGUI(PlayerEntity playerEntity) {
        if (!this.field_70170_p.field_72995_K && (!this.func_184207_aI() || this.func_184196_w((Entity)playerEntity)) && this.func_70909_n()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)this, buf -> buf.writeInt(this.func_145782_y()));
        }
    }

    @Nonnull
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return new ContainerPelican(windowId, inventory, this);
    }

    protected void initPelicanInventory() {
        this.pelicanInventory = new ItemStackHandler(5){

            public int getSlotLimit(int slot) {
                return 64;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
            }
        };
        int i = Math.min(this.pelicanInventory.getSlots(), this.pelicanInventory.getSlots());
        for (int j = 0; j < i; ++j) {
            ItemStack itemstack = this.pelicanInventory.getStackInSlot(j);
            if (itemstack.func_190926_b()) continue;
            this.pelicanInventory.setStackInSlot(j, itemstack.func_77946_l());
        }
        this.itemHandler = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.pelicanInventory, 0, 5));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.func_70089_S() && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        if (!keepData && this.itemHandler != null) {
            this.itemHandler.invalidate();
            this.itemHandler = null;
        }
    }

    public void fishUpItem() {
        if (!this.field_70170_p.field_72995_K && this.pelicanInventory != null && !this.func_70631_g_()) {
            float f = this.field_70146_Z.nextFloat();
            ItemStack fishStack = f < 0.05f ? new ItemStack((IItemProvider)Items.field_196089_aZ) : (f < 0.3f ? new ItemStack((IItemProvider)Items.field_196088_aY) : (f < 0.65f ? new ItemStack((IItemProvider)Items.field_196087_aX) : new ItemStack((IItemProvider)Items.field_196086_aW)));
            boolean storedFish = false;
            for (int i = 0; i < this.pelicanInventory.getSlots(); ++i) {
                if (this.pelicanInventory.getStackInSlot(i).func_190926_b()) {
                    this.pelicanInventory.setStackInSlot(i, fishStack);
                    storedFish = true;
                    break;
                }
                if (!this.pelicanInventory.getStackInSlot(i).func_77969_a(fishStack) || this.pelicanInventory.getStackInSlot(i).func_190916_E() >= this.pelicanInventory.getStackInSlot(i).func_77976_d()) continue;
                this.pelicanInventory.getStackInSlot(i).func_190917_f(1);
                storedFish = true;
                break;
            }
            if (!storedFish) {
                this.func_70099_a(fishStack, 1.0f);
            }
            this.func_184185_a(SoundEvents.field_187808_ef, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        }
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.func_70631_g_() ? EntitySize.func_220314_b((float)0.5f, (float)0.85f) : super.func_213305_a(poseIn);
    }

    class FishUpFishGoal
    extends Goal {
        private int timeUntilFish;

        FishUpFishGoal() {
            this.timeUntilFish = EntityPelican.this.func_70681_au().nextInt(2000) + 2000;
        }

        public boolean func_75250_a() {
            return ExoticBirdsConfig.pelicanScavenge && this.timeUntilFish-- < 0;
        }

        public void func_75249_e() {
            this.timeUntilFish = EntityPelican.this.func_70681_au().nextInt(2000) + 2000;
            EntityPelican.this.fishUpItem();
        }
    }

    static class TemptGoal
    extends net.minecraft.entity.ai.goal.TemptGoal {
        private final EntityPelican pelican;

        public TemptGoal(EntityPelican pelicanIn, double speedIn, Ingredient temptItemsIn, boolean scaredByMovement) {
            super((CreatureEntity)pelicanIn, speedIn, temptItemsIn, scaredByMovement);
            this.pelican = pelicanIn;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.pelican.func_70909_n();
        }
    }
}

